/*==============================================================================
Message holder for Harassment 101.

This is where the Decapitated Messages, Perfect Messages and Sounds, and the
Taunt messages are Displayed.
==============================================================================*/
class HSMessage extends CriticalEventPlus;

var color HeadshotColor, TauntColor, PerfectColor;
var string HeadshotMessage[25];
var string PerfectMessage[25];
var string TauntMessage[10];
var string ClanTag;

static function float GetOffset(int Switch, float YL, float ClipY )
{
	if ( switch < 25 ) //LLamas
		return ClipY - YL - 0.0833*ClipY;
	else if ( switch > 39 && switch < 50 ) //Taunts
		return ClipY - YL*3 - 0.0833*ClipY;
	else if ( switch > 49 && switch < 75 ) //Perfects
		return ClipY - YL*5 - 0.0833*ClipY;
}

static function color GetColor(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2 )
{
	if ( switch < 25 ) //LLamas
		return default.HeadshotColor;
	else if ( switch > 39 && switch < 50 ) //Taunts
		return default.TauntColor;
	else if ( switch > 49 && switch < 100 ) //Perfects
		return default.PerfectColor;
}

static function string GetString(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject )
{
	local string Msg;
	local int NameLength, TagLength, TagLocation;

	if ( switch < 25 ) //LLamas 0-24
		Msg = default.HeadshotMessage[switch];
	else if ( switch > 39 && switch < 50 ) //Taunts 40-49
		Msg = default.TauntMessage[switch-40];
	else if ( switch > 49 && switch < 75 ) //Perfects  50-74
		Msg = default.PerfectMessage[switch-50];

	//Killer
	if ( RelatedPRI_1 != None )
	{
		TagLocation = 0;
		NameLength = 0;
		TagLocation = Instr(caps(RelatedPRI_1.PlayerName), caps(default.ClanTag) );
		TagLength = Len(caps(default.ClanTag));
		NameLength = Len(caps(RelatedPRI_1.PlayerName));

		ReplaceText(Msg, "%k", RelatedPRI_1.PlayerName);

		if ( TagLocation < 0 )
			ReplaceText(Msg, "%y", RelatedPRI_1.PlayerName );
		else if ( TagLocation == 0 )
			ReplaceText(Msg, "%y", Mid(RelatedPRI_1.PlayerName,TagLength) );
		else
			ReplaceText(Msg, "%y", Mid(RelatedPRI_1.PlayerName,0,NameLength - TagLength) );

		if ( RelatedPRI_1.bIsFemale )
		{
			ReplaceText(Msg, "%g", "her");
			ReplaceText(Msg, "%h", "she");
		}
		else
		{
			ReplaceText(Msg, "%g", "his");
			ReplaceText(Msg, "%h", "he");
		}
	}
	//Victim
	if ( RelatedPRI_2 != None )
	{
		TagLocation = 0;
		NameLength = 0;
		TagLocation = Instr(caps(RelatedPRI_2.PlayerName), caps(default.ClanTag) );
		TagLength = Len(caps(default.ClanTag));
		NameLength = Len(caps(RelatedPRI_2.PlayerName));

		ReplaceText(Msg, "%o", RelatedPRI_2.PlayerName);

		if ( TagLocation < 0 )
			ReplaceText(Msg, "%z", RelatedPRI_2.PlayerName );
		else if ( TagLocation == 0 )
			ReplaceText(Msg, "%z", Mid(RelatedPRI_2.PlayerName,TagLength) );
		else
			ReplaceText(Msg, "%z", Mid(RelatedPRI_2.PlayerName,0,NameLength - TagLength) );

		if ( RelatedPRI_2.bIsFemale )
		{
			ReplaceText(Msg, "%i", "her");
			ReplaceText(Msg, "%j", "she");
		}
		else
		{
			ReplaceText(Msg, "%i", "his");
			ReplaceText(Msg, "%j", "he");
		}
	}

	return Msg;
}

static final function ReplaceText(
	out string Text,
	coerce string Replace,
	coerce string With )
{
	local int i;
	local string Input;

	Input = Text;
	Text = "";
	i = InStr(Input, Replace);

	while (i != -1)
	{
		Text = Text $ Left(Input, i) $ With;
		Input = Mid(Input, i + Len(Replace));
		i = InStr(Input, Replace);
	}

	Text = Text $ Input;
}

defaultproperties
{
	bBeep=False
	Lifetime=8
}
